/*
 * Decompiled with CFR 0.152.
 */
package tm2;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import tm2.Alphabet;
import tm2.Cell;
import tm2.Ins;
import tm2.TL;
import tm2.Tape;

class TapeWin
extends Component
implements MouseListener {
    private TL tl;
    public Cell pick;
    public int pickx;
    public int picky;
    private Dimension lastSize;
    private Image b;

    public TapeWin(TL tL) {
        this.tl = tL;
        new Dimension(517, 16);
        this.setSize(517, 17);
        this.addMouseListener(this);
        this.enableEvents(8L);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        Dimension dimension = this.getSize();
        if (this.b == null || dimension.width != this.lastSize.width || dimension.height != this.lastSize.height) {
            if (this.b != null) {
                this.b.flush();
                System.gc();
            }
            this.b = this.createImage(dimension.width + 2, dimension.height + 2);
            this.lastSize = dimension;
        }
        Graphics graphics2 = this.b.getGraphics();
        FontMetrics fontMetrics = this.getToolkit().getFontMetrics(graphics.getFont());
        graphics2.setColor(Color.black);
        graphics2.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
        graphics2.setColor(Tape.tape);
        graphics2.fillRect(1, 1, dimension.width - 2, dimension.height - 2);
        Cell cell = this.tl.lockedAt;
        int n = dimension.width;
        int n2 = (n - 14) / 2;
        int n3 = 0;
        while (n3 < n2) {
            if (cell.prev == null) {
                cell.prev = new Cell(Ins.alphabet.getBlank(), null, cell);
            }
            cell = cell.prev;
            n3 += 14;
        }
        int n4 = 0;
        while (n4 < n) {
            if (cell == this.tl.head) {
                graphics2.setColor(Tape.head);
                graphics2.fillRect(n4, 1, 15, 15);
                graphics2.setColor(Tape.headText);
            } else if (cell == this.tl.selected) {
                graphics2.setColor(Tape.selected);
                graphics2.fillRect(n4, 1, 15, 15);
                graphics2.setColor(Tape.selectedText);
            } else {
                graphics2.setColor(Tape.text);
            }
            graphics2.drawString(String.valueOf(cell.data), n4 + 7 - fontMetrics.charWidth(cell.data) / 2, 12);
            graphics2.setColor(Color.black);
            graphics2.drawLine(n4, 1, n4, 15);
            if (cell.next == null) {
                cell.next = new Cell(Ins.alphabet.getBlank(), cell, null);
            }
            cell = cell.next;
            n4 += 14;
        }
        graphics.drawImage(this.b, 0, 0, this);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        Dimension dimension = this.getSize();
        int n = dimension.width;
        int n2 = (n - 14) / 2;
        Cell cell = this.tl.lockedAt;
        int n3 = 0;
        while (n3 < n2) {
            cell = cell.prev;
            n3 += 14;
        }
        int n4 = 0;
        while (n4 < n) {
            if (mouseEvent.getX() > n4 && mouseEvent.getX() < n4 + 14) {
                this.pick = cell;
            }
            cell = cell.next;
            n4 += 14;
        }
        if (mouseEvent.getClickCount() == 1) {
            this.tl.selected = this.pick;
        } else if (mouseEvent.getClickCount() == 2) {
            this.tl.head = this.pick;
        }
        this.requestFocus();
        this.paint(this.getGraphics());
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        int n = keyEvent.getID();
        if (n == 400) {
            char c = keyEvent.getKeyChar();
            if (c == '\u0000') {
                return;
            }
            if (c == '\b') {
                this.tl.selected.data = Alphabet.blank;
                this.tl.moveSelected('L');
            } else {
                this.tl.selected.data = c;
                this.tl.moveSelected('R');
            }
            this.paint(this.getGraphics());
        } else if (n == 401) {
            int n2 = keyEvent.getKeyCode();
            if (n2 == 37) {
                this.tl.moveSelected('L');
            } else if (n2 == 39) {
                this.tl.moveSelected('R');
            }
            this.paint(this.getGraphics());
        }
        super.processKeyEvent(keyEvent);
    }
}

