/*
 * Decompiled with CFR 0.152.
 */
package mdgawt;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;
import mdgawt.FPoint;
import mdgawt.MyCanvas;
import mdgawt.MyPopup;
import mdgawt.Vector2d;

public class MyComponent
extends Canvas {
    public static final int LINE = 1;
    public static final int BARC = 2;
    public static final int HARC = 3;
    public String[] arcNames = new String[]{"Line", "Bezier Curve", "Hermite Curve"};
    public static int defaultType = 1;
    public static boolean lockLinks = true;
    public static Color link = Color.red;
    public static Color arrow = Color.black;
    protected MyCanvas parent;
    public String saveName = new String("");
    public String savePath = new String("");
    public boolean isRemovable = true;
    public int travelx = (int)(Math.random() * 5.0);
    public int travely = (int)(Math.random() * 5.0);
    public int arcType = defaultType;
    private String name = new String("");
    protected MyCanvas myChild;
    public Color foreground = new Color(0, 0, 0);
    public Color background = new Color(0, 0, 0);
    public boolean visible = true;
    public boolean active = false;
    public boolean isLinkable = false;
    public Vector links = new Vector(0);
    public int x;
    public int y;
    public int width;
    public int height;

    public MyComponent() {
    }

    public MyComponent(String string, int n, int n2) {
        this.setText(string);
        this.setLocation(n, n2);
    }

    public boolean isLinkedTo(MyComponent myComponent) {
        int n = 0;
        while (n < this.links.size()) {
            if (this.links.elementAt(n) == myComponent) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void removeAllLinks() {
        this.links = new Vector(0);
    }

    public void removeLink(MyComponent myComponent) {
        this.links.removeElement(myComponent);
    }

    public void addLink(MyComponent myComponent) {
        this.links.addElement(myComponent);
    }

    public void setArcType(int n) {
        this.arcType = n;
    }

    public void setForeground(Color color) {
        this.foreground = color;
    }

    public void setBackground(Color color) {
        this.background = color;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public void setSize(int n, int n2) {
        this.width = n;
        this.height = n2;
    }

    public void setLocation(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    public void setCenter(int n, int n2) {
        this.x = n - this.height / 2;
        this.y = n2 - this.height / 2;
    }

    public void setText(String string) {
        this.name = string;
    }

    public void setOwner(MyCanvas myCanvas) {
        this.parent = myCanvas;
    }

    public void setActive(boolean bl) {
        this.active = bl;
    }

    public boolean isActive() {
        return this.active;
    }

    public MyCanvas getOwner() {
        return this.parent;
    }

    public MyCanvas getChild() {
        return this.myChild;
    }

    public MyComponent getLink(int n) {
        if (n < 0 || n >= this.links.size()) {
            return null;
        }
        return (MyComponent)this.links.elementAt(n);
    }

    public Color getNameForeground() {
        return this.foreground;
    }

    public Color getNameBackground() {
        return this.background;
    }

    public Color getTextForeground() {
        return this.foreground;
    }

    public Color getTextBackground() {
        return this.background;
    }

    public Color getForeground() {
        return this.foreground;
    }

    public Color getBackground() {
        return this.background;
    }

    public Point getCenter() {
        return new Point(this.x + this.width / 2, this.y + this.height / 2);
    }

    public Point getLocation() {
        return new Point(this.x, this.y);
    }

    public Point getTravel() {
        return new Point(this.travelx, this.travely);
    }

    public Dimension getSize() {
        return new Dimension(this.width, this.height);
    }

    public String getArcName() {
        return this.arcNames[this.arcType - 1];
    }

    public String getText() {
        return this.name;
    }

    public void grabClosest() {
    }

    public boolean clip(Rectangle rectangle) {
        Point point = rectangle.getLocation();
        Dimension dimension = rectangle.getSize();
        return this.x + this.width < point.x || this.x > point.x + dimension.width || this.y + this.height < point.y || this.y > point.y + dimension.width;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void translate(int n, int n2) {
        this.x += n;
        this.y += n2;
    }

    public boolean isInside(int n, int n2) {
        return n >= this.x && n2 >= this.y && n < this.x + this.width && n2 < this.y + this.height;
    }

    public boolean intersects(MyComponent myComponent) {
        return myComponent.x <= this.x + this.width && myComponent.x + myComponent.width >= this.x && myComponent.y <= this.y + this.height && myComponent.y + myComponent.height >= this.y;
    }

    public void add(MyPopup myPopup) {
    }

    public void createPopupMenu(MyCanvas myCanvas) {
    }

    public void createDialog(Component component) {
    }

    public static MyComponent fromString(String string) {
        return null;
    }

    public String toString() {
        return new String(String.valueOf('\"') + this.name + '\"' + ';' + this.x + ';' + this.y + ';' + this.width + ';' + this.height + ';');
    }

    public void paintLink(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        Point point = this.getCenter();
        int n = 1;
        while (n < this.links.size()) {
            Object object;
            Point point2 = ((MyComponent)this.links.elementAt(0)).getCenter();
            Point point3 = ((MyComponent)this.links.elementAt(n)).getCenter();
            graphics.setColor(link);
            if (this.arcType == 1) {
                float f = point3.x - point.x;
                float f2 = point3.y - point.y;
                float f3 = (float)(Math.sqrt(f * f + f2 * f2) / 20.0);
                object = new Point((int)(f / f3 + (float)point.x), (int)(f2 / f3 + (float)point.y));
                if (point2 == point3) {
                    object = point;
                }
                graphics.drawLine(point2.x, point2.y, point.x, point.y);
                graphics.drawLine(point3.x, point3.y, ((Point)object).x, ((Point)object).y);
                graphics.setColor(arrow);
                if (point2 != point3) {
                    int n2 = -4;
                    while (n2 <= 4) {
                        graphics.drawLine(((Point)object).x, ((Point)object).y, point.x + n2, point.y);
                        graphics.drawLine(((Point)object).x, ((Point)object).y, point.x, point.y + n2);
                        ++n2;
                    }
                }
            } else if (this.arcType == 2 || this.arcType == 3) {
                FPoint fPoint;
                Vector vector;
                Vector vector2;
                Vector2d vector2d;
                Vector2d vector2d2;
                Vector2d vector2d3;
                FPoint fPoint2 = new FPoint(point3.x - point2.x, point3.y - point2.y);
                if (point2.x == point3.x && point2.y == point3.y) {
                    Vector2d vector2d4 = new Vector2d(point.x - point2.x, point.y - point2.y);
                    vector2d3 = new Vector2d(vector2d4.x, vector2d4.y);
                    vector2d3.rotate(20.0);
                    vector2d2 = new Vector2d(vector2d4.x, vector2d4.y);
                    vector2d2.rotate(270.0);
                    vector2d = new Vector2d(vector2d4.x, vector2d4.y);
                    vector2d.rotate(160.0);
                } else {
                    vector2d2 = new Vector2d(fPoint2.x, fPoint2.y);
                    object = new Vector2d(point.x - point2.x, point.y - point2.y);
                    vector2d3 = new Vector2d(point.x - point2.x, point.y - point2.y);
                    vector2d = new Vector2d(point3.x - point.x, point3.y - point.y);
                    double d = Math.acos((vector2d2.x * ((Vector2d)object).x + vector2d2.y * ((Vector2d)object).y) / (Math.sqrt(vector2d2.x * vector2d2.x + vector2d2.y * vector2d2.y) * Math.sqrt(((Vector2d)object).x * ((Vector2d)object).x + ((Vector2d)object).y * ((Vector2d)object).y)));
                    if (d > Math.PI) {
                        vector2d3.x = -vector2d3.x;
                        vector2d3.y = -vector2d3.y;
                        vector2d.x = -vector2d.x;
                        vector2d.y = -vector2d.y;
                    }
                }
                if (this.arcType == 3) {
                    vector2 = this.getARC(point2, vector2d3, vector2d2, point, graphics);
                    vector = this.getARC(point, vector2d2, vector2d, point3, graphics);
                } else {
                    vector2 = this.getBezierArc(point2, point, point, point3, graphics);
                    vector = new Vector();
                }
                int n3 = 0;
                while (n3 < vector.size()) {
                    vector2.addElement(vector.elementAt(n3));
                    ++n3;
                }
                double d = 10000.0;
                FPoint fPoint3 = new FPoint(this.x, this.y);
                double d2 = Math.sqrt((point.x - point3.x) * (point.x - point3.x) + (point.y - point3.y) * (point.y - point3.y));
                int n4 = vector2.size() / 2;
                while (n4 < vector2.size()) {
                    fPoint = (FPoint)vector2.elementAt(n4);
                    double d3 = Math.sqrt(((double)point.x - fPoint.x) * ((double)point.x - fPoint.x) + ((double)point.y - fPoint.y) * ((double)point.y - fPoint.y));
                    double d4 = Math.abs(Math.abs(d3) - 20.0);
                    if (d4 < d && Math.sqrt(((double)point3.x - fPoint.x) * ((double)point3.x - fPoint.x) + ((double)point3.y - fPoint.y) * ((double)point3.y - fPoint.y)) < d2) {
                        d = d4;
                        fPoint3 = fPoint;
                    }
                    ++n4;
                }
                graphics.setColor(link);
                int n5 = 0;
                while (n5 < vector2.size() - 1) {
                    fPoint = (FPoint)vector2.elementAt(n5);
                    FPoint fPoint4 = (FPoint)vector2.elementAt(n5 + 1);
                    graphics.drawLine((int)fPoint.x, (int)fPoint.y, (int)fPoint4.x, (int)fPoint4.y);
                    ++n5;
                }
                graphics.setColor(arrow);
                int n6 = -4;
                while (n6 <= 4) {
                    graphics.drawLine((int)fPoint3.x, (int)fPoint3.y, point.x + n6, point.y);
                    graphics.drawLine((int)fPoint3.x, (int)fPoint3.y, point.x, point.y + n6);
                    ++n6;
                }
            }
            ++n;
        }
    }

    private Vector getARC(Point point, Vector2d vector2d, Vector2d vector2d2, Point point2, Graphics graphics) {
        Vector<FPoint> vector = new Vector<FPoint>();
        double d = 0.05;
        int n = 0;
        while ((double)n < 20.0) {
            double d2 = (double)n * d;
            double d3 = d2 * d2;
            double d4 = d3 * d2;
            double d5 = (2.0 * d4 - 3.0 * d3 + 1.0) * (double)point.x + (-2.0 * d4 + 3.0 * d3) * (double)point2.x + (d4 - 2.0 * d3 + d2) * vector2d.x + (d4 - d3) * vector2d2.x;
            double d6 = (2.0 * d4 - 3.0 * d3 + 1.0) * (double)point.y + (-2.0 * d4 + 3.0 * d3) * (double)point2.y + (d4 - 2.0 * d3 + d2) * vector2d.y + (d4 - d3) * vector2d2.y;
            vector.addElement(new FPoint(d5, d6));
            ++n;
        }
        return vector;
    }

    private Vector getBezierArc(Point point, Point point2, Point point3, Point point4, Graphics graphics) {
        Vector<FPoint> vector = new Vector<FPoint>();
        double d = 0.05;
        int n = 0;
        while ((double)n < 20.0) {
            double d2 = 1.0 - (double)n * d;
            double d3 = d2 * d2;
            double d4 = d3 * d2;
            double d5 = 1.0 - d2;
            double d6 = d5 * d5;
            double d7 = d6 * d5;
            double d8 = d7 * (double)point.x + 3.0 * d2 * d6 * (double)point2.x + 3.0 * d3 * d5 * (double)point3.x + d4 * (double)point4.x;
            double d9 = d7 * (double)point.y + 3.0 * d2 * d6 * (double)point2.y + 3.0 * d3 * d5 * (double)point3.y + d4 * (double)point4.y;
            vector.addElement(new FPoint(d8, d9));
            ++n;
        }
        return vector;
    }
}

