/*
 * Decompiled with CFR 0.152.
 */
package mdgawt;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.PrintJob;
import java.awt.ScrollPane;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.PrintWriter;
import java.util.Properties;
import java.util.Vector;
import mdgawt.BoxRunner;
import mdgawt.GSP;
import mdgawt.MenuBarWithEditMenu;
import mdgawt.MyCanvasMover;
import mdgawt.MyComponent;
import mdgawt.MyPopup;
import mdgawt.Undo;

public class MyCanvas
extends MyComponent
implements WindowListener,
MouseListener,
MouseMotionListener {
    public static Color graph = new Color(0, 0, 0);
    public static Color grid = new Color(0, 0, 0);
    public static int gridSize = 16;
    public static boolean debug;
    public static boolean gridOn;
    public static boolean snapToGridOn;
    public static boolean dragLinksTo;
    private static final int maxUndos = 10;
    public static final int NORMAL = 0;
    public static final int ADD_ARC_PHASE_ONE = 1;
    public static final int ADD_ARC_PHASE_TWO = 2;
    public static final int BINDING = 3;
    public static final int BOXING = 4;
    public static final int PASTING = 5;
    public static Vector copied;
    public Vector undos = new Vector();
    protected MyPopup mpum;
    protected MenuBarWithEditMenu mbwm;
    public int editMode;
    protected MyComponent pick;
    protected BoxRunner boxRunner = new BoxRunner();
    public Frame myFrame = new Frame();
    protected ScrollPane sp = new GSP();
    protected Vector myComps = new Vector(10, 10);
    protected Dimension lastSize = new Dimension(100, 100);
    protected Image b;
    protected boolean closedPopup = false;
    protected boolean hasBeenEdited = true;
    public boolean editedSinceSave = false;
    MyCanvasMover mcm;
    public int lastTime;
    Image background;
    boolean backgroundOn = false;

    public MyCanvas() {
        this.sp.add(this);
        this.myFrame.setLayout(new BorderLayout());
        this.myFrame.add("Center", this.sp);
        this.myFrame.addWindowListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.mcm = new MyCanvasMover(this);
    }

    public void moveComps() {
        Dimension dimension = this.getSize();
        int n = 0;
        while (n < this.myComps.size()) {
            MyComponent myComponent = this.getComp(n);
            Dimension dimension2 = myComponent.getSize();
            Point point = myComponent.getLocation();
            Point point2 = myComponent.getTravel();
            if (point.x + point2.x + dimension2.width > dimension.width || point.x + point2.x < 0) {
                myComponent.travelx *= -1;
            }
            if (point.y + point2.y + dimension2.height > dimension.height || point.y + point2.y < 0) {
                myComponent.travely *= -1;
            }
            myComponent.setLocation(point.x + myComponent.travelx, point.y + myComponent.travely);
            ++n;
        }
        this.hasBeenEdited = true;
        this.paint(this.getGraphics());
    }

    public void save(PrintWriter printWriter) {
        MyComponent myComponent;
        printWriter.println("<START>");
        int n = 0;
        while (n < this.myComps.size()) {
            myComponent = (MyComponent)this.myComps.elementAt(n);
            printWriter.println(myComponent.toString());
            if (myComponent.myChild != null) {
                myComponent.myChild.save(printWriter);
            }
            ++n;
        }
        printWriter.println("<LINKS>");
        int n2 = 0;
        while (n2 < this.myComps.size()) {
            myComponent = (MyComponent)this.myComps.elementAt(n2);
            String string = new String("" + n2 + ';');
            int n3 = 0;
            while (n3 < myComponent.links.size()) {
                string = new String(String.valueOf(string) + this.myComps.indexOf(myComponent.links.elementAt(n3)) + ';');
                ++n3;
            }
            printWriter.println(string);
            ++n2;
        }
        printWriter.println("<END>");
    }

    public MyComponent createFromString(String string) {
        return null;
    }

    public void cascade(int n) {
        int n2 = 0;
        while (n2 < this.myComps.size()) {
            MyComponent myComponent = (MyComponent)this.myComps.elementAt(n2);
            if (myComponent.myChild != null) {
                if (myComponent.myChild.myFrame.isVisible()) {
                    ((Component)myComponent.myChild.myFrame).setLocation(n % 400, n % 400);
                    myComponent.myChild.myFrame.toFront();
                }
                myComponent.myChild.cascade(n + 25);
            }
            ++n2;
        }
    }

    public int firstInstanceOf(String string) {
        int n = 0;
        while (n < this.myComps.size()) {
            if (this.getComp(n).getClass().getName().equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int lastInstanceOf(String string) {
        int n = this.myComps.size() - 1;
        while (n >= 0) {
            if (this.getComp(n).getClass().getName().equals(string)) {
                return n;
            }
            --n;
        }
        return -2;
    }

    public void sortByClass() {
        int n = 0;
        while (n < this.myComps.size() - 1) {
            int n2 = 0;
            while (n2 < this.myComps.size() - n - 1) {
                MyComponent myComponent = this.getComp(n2);
                MyComponent myComponent2 = this.getComp(n2 + 1);
                if (myComponent.getClass().getName().compareTo(myComponent2.getClass().getName()) > 0) {
                    this.myComps.setElementAt(myComponent2, n2);
                    this.myComps.setElementAt(myComponent, n2 + 1);
                }
                ++n2;
            }
            ++n;
        }
    }

    public void sortByLinkText(int n, int n2, int n3) {
        if (debug) {
            System.out.println("Sorting from " + n + " to " + n2 + " on link " + n3);
        }
        if (n2 >= this.myComps.size()) {
            return;
        }
        int n4 = n;
        while (n4 <= n2 - 1) {
            int n5 = n;
            while (n5 <= n2 - (n4 - n) - 1) {
                MyComponent myComponent = this.getComp(n5);
                MyComponent myComponent2 = this.getComp(n5 + 1);
                if (debug) {
                    System.out.println("Comparing " + n5 + " and " + (n5 + 1));
                }
                if (n3 < myComponent.links.size() - 1 && n3 < myComponent2.links.size() - 1 && myComponent.getLink(n3).toString().compareTo(myComponent2.getLink(n3).toString()) > 0) {
                    this.myComps.setElementAt(myComponent2, n5);
                    this.myComps.setElementAt(myComponent, n5 + 1);
                }
                ++n5;
            }
            ++n4;
        }
    }

    public void openAll() {
        int n = 0;
        while (n < this.myComps.size()) {
            MyComponent myComponent = this.getComp(n);
            if (myComponent.myChild != null) {
                ((Component)myComponent.myChild.myFrame).setVisible(true);
                myComponent.myChild.openAll();
            }
            ++n;
        }
        this.cascade(25);
    }

    public void closeAll() {
        if (debug) {
            System.out.println("in MyCanvas:closeAll()");
        }
        int n = 0;
        while (n < this.myComps.size()) {
            MyComponent myComponent = (MyComponent)this.myComps.elementAt(n);
            if (myComponent.myChild != null) {
                ((Component)myComponent.myChild.myFrame).setVisible(false);
                myComponent.myChild.closeAll();
            }
            ++n;
        }
    }

    public void minimizeCanvas() {
        Point point;
        MyComponent myComponent;
        int n = 10;
        int n2 = 10;
        int n3 = 4000;
        int n4 = 4000;
        int n5 = 0;
        while (n5 < this.myComps.size()) {
            myComponent = (MyComponent)this.myComps.elementAt(n5);
            point = myComponent.getLocation();
            Dimension dimension = myComponent.getSize();
            if (point.x + dimension.width > n) {
                n = point.x + dimension.width;
            }
            if (point.y + dimension.height > n2) {
                n2 = point.y + dimension.height;
            }
            if (point.x < n3) {
                n3 = point.x;
            }
            if (point.y < n4) {
                n4 = point.y;
            }
            ++n5;
        }
        int n6 = n3 - 50;
        int n7 = n4 - 50;
        int n8 = 0;
        while (n8 < this.myComps.size()) {
            myComponent = (MyComponent)this.myComps.elementAt(n8);
            point = myComponent.getLocation();
            myComponent.setLocation(point.x - n6, point.y - n7);
            ++n8;
        }
        this.setSize(Math.max(n - n3 + 100, 200), Math.max(n2 - n4 + 100, 200));
    }

    public Vector copy() {
        if (!this.boxRunner.isRunning) {
            return null;
        }
        Vector<MyComponent> vector = new Vector<MyComponent>(4, 4);
        int n = 0;
        while (n < this.myComps.size()) {
            MyComponent myComponent = this.getComp(n);
            if (myComponent.intersects(this.boxRunner)) {
                vector.addElement(myComponent);
            }
            ++n;
        }
        this.mbwm.enableEditMenu();
        return vector;
    }

    public void addUndo(Undo undo) {
        this.undos.addElement(undo);
    }

    public void removeAll() {
        this.editedSinceSave = true;
        Vector<MyComponent> vector = new Vector<MyComponent>(4, 4);
        int n = 0;
        while (n < this.myComps.size()) {
            MyComponent myComponent = this.getComp(n);
            if (!myComponent.isRemovable) {
                vector.addElement(myComponent);
            }
            ++n;
        }
        this.myComps = vector;
    }

    public void remove(MyComponent myComponent) {
        this.editedSinceSave = true;
        if (debug) {
            System.out.println("in MyCanvas:remove()");
        }
        Undo undo = new Undo("Delete State");
        this.remove(myComponent, undo);
        this.addUndo(undo);
    }

    public void remove(MyComponent myComponent, Undo undo) {
        this.editedSinceSave = true;
        if (debug) {
            System.out.println("in MyCanvas:remove2()");
        }
        int n = 0;
        while (n < this.myComps.size()) {
            MyComponent myComponent2 = this.getComp(n);
            if (myComponent2 == myComponent) {
                if (myComponent2.myChild != null) {
                    myComponent2.myChild.closeAll();
                    ((Component)myComponent2.myChild.myFrame).setVisible(false);
                }
                this.myComps.removeElement(myComponent2);
                this.removeAttached(myComponent2, undo);
                undo.addElement(myComponent2);
                n = 0;
            }
            ++n;
        }
        this.fixData();
        this.fullRepaint();
    }

    protected void fixData() {
    }

    private void removeAttached(MyComponent myComponent, Undo undo) {
        this.editedSinceSave = true;
        if (debug) {
            System.out.println("in MyCanvas:removeAttached()");
        }
        if (debug) {
            System.out.println("mc = " + myComponent.getClass());
        }
        int n = 0;
        while (n < this.myComps.size()) {
            MyComponent myComponent2 = this.getComp(n);
            if (myComponent2.isLinkedTo(myComponent)) {
                if (!myComponent2.isRemovable) {
                    myComponent2.grabClosest();
                } else {
                    this.remove(myComponent2, undo);
                    n = 0;
                }
            }
            ++n;
        }
    }

    public Undo delete() {
        this.editedSinceSave = true;
        if (!this.boxRunner.isRunning) {
            return null;
        }
        Undo undo = new Undo("Delete");
        int n = 0;
        while (n < this.myComps.size()) {
            MyComponent myComponent = this.getComp(n);
            if (myComponent.intersects(this.boxRunner)) {
                this.remove(myComponent, undo);
                n = 0;
            }
            ++n;
        }
        return undo;
    }

    public MyComponent getClosest(String string, int n, int n2) {
        double d = Double.MAX_VALUE;
        MyComponent myComponent = null;
        MyComponent myComponent2 = null;
        int n3 = 0;
        while (n3 < this.myComps.size()) {
            myComponent2 = this.getComp(n3);
            if (myComponent2.getClass().getName().equals(string)) {
                Point point = myComponent2.getLocation();
                double d2 = Math.sqrt((point.x - n) * (point.x - n) + (point.y - n2) * (point.y - n2));
                if (d2 < d) {
                    d = d2;
                    myComponent = myComponent2;
                }
            }
            ++n3;
        }
        return myComponent;
    }

    public boolean intersects(MyComponent myComponent) {
        int n = 0;
        while (n < this.myComps.size()) {
            MyComponent myComponent2 = this.getComp(n);
            if (myComponent2.intersects(myComponent) && myComponent2 != myComponent) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected MyComponent addMCNF(MyComponent myComponent) {
        this.editedSinceSave = true;
        this.myComps.addElement(myComponent);
        myComponent.parent = this;
        if (debug && myComponent.parent == null) {
            System.out.println("mc.parent=null");
        }
        return myComponent;
    }

    public MyComponent addMC(MyComponent myComponent) {
        this.editedSinceSave = true;
        this.myComps.addElement(myComponent);
        myComponent.parent = this;
        if (debug && myComponent.parent == null) {
            System.out.println("mc.parent=null");
        }
        this.fixData();
        return myComponent;
    }

    public MyComponent find(String string, String string2) {
        int n = 0;
        while (n < this.myComps.size()) {
            if (this.getComp(n).getText().equals(string2)) {
                return this.getComp(n);
            }
            ++n;
        }
        return null;
    }

    public MyComponent locateMC(int n, int n2) {
        if (this.mpum != null && this.mpum.isInside(n, n2)) {
            return this.mpum;
        }
        int n3 = 0;
        while (n3 < this.myComps.size()) {
            MyComponent myComponent = this.getComp(n3);
            if (myComponent.isVisible() && myComponent.isInside(n, n2)) {
                return myComponent;
            }
            ++n3;
        }
        return null;
    }

    public void print() {
        PrintJob printJob = this.getToolkit().getPrintJob(this.myFrame, "test", new Properties());
        Graphics graphics = printJob.getGraphics();
        this.hasBeenEdited = true;
        if (graphics == null) {
            System.out.println("gg=====null");
        }
        graphics.setColor(Color.black);
        graphics.drawImage(this.b, 0, 0, this);
        graphics.dispose();
        printJob.end();
    }

    public void fullRepaint() {
        this.hasBeenEdited = true;
        this.repaint();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void repaintAllGraphs() {
        this.fullRepaint();
        int n = 0;
        while (n < this.myComps.size()) {
            MyComponent myComponent = (MyComponent)this.myComps.elementAt(n);
            if (myComponent.myChild != null) {
                myComponent.myChild.repaintAllGraphs();
            }
            ++n;
        }
    }

    public void paint(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        Dimension dimension = this.getSize();
        if (this.backgroundOn && this.background == null) {
            this.getToolkit().getImage("theweb.gif");
        }
        if (this.b == null || dimension.width != this.lastSize.width || dimension.height != this.lastSize.height) {
            this.hasBeenEdited = true;
            this.b = this.createImage(dimension.width + 1, dimension.height + 1);
        }
        this.lastSize = dimension;
        Graphics graphics2 = this.b.getGraphics();
        if (this.hasBeenEdited) {
            int n;
            int n2;
            graphics2.setColor(graph);
            if (this.backgroundOn && this.background == null) {
                graphics2.drawImage(this.background, 0, 0, this);
            } else {
                graphics2.fillRect(0, 0, dimension.width, dimension.height);
            }
            if (gridOn) {
                graphics2.setColor(grid);
                n2 = 0;
                while (n2 < dimension.width) {
                    graphics2.drawLine(n2, 0, n2, dimension.height);
                    n2 += gridSize;
                }
                n = 0;
                while (n < dimension.height) {
                    graphics2.drawLine(0, n, dimension.width, n);
                    n += gridSize;
                }
            }
            graphics2.setColor(Color.black);
            graphics2.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
            n2 = 0;
            while (n2 < this.myComps.size()) {
                this.getComp(n2).paintLink(graphics2);
                ++n2;
            }
            n = 0;
            while (n < this.myComps.size()) {
                this.getComp(n).paint(graphics2);
                ++n;
            }
        }
        if (this.mpum != null) {
            this.mpum.paint(graphics2);
        }
        graphics.drawImage(this.b, 0, 0, this);
        this.hasBeenEdited = false;
    }

    public void setEditMode(int n) {
        this.editMode = n;
    }

    public MyComponent getComp(int n) {
        if (n < 0 || n >= this.myComps.size()) {
            return null;
        }
        return (MyComponent)this.myComps.elementAt(n);
    }

    public void add(MyPopup myPopup) {
        this.mpum = myPopup;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.getSize().width, this.getSize().height);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void setGridSize(int n) {
        this.editedSinceSave = true;
        gridSize = n;
    }

    public int getGridSize() {
        return gridSize;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.lastTime = 0;
        if (this.mpum != null) {
            this.mpum.highlight(mouseEvent.getX(), mouseEvent.getY());
        }
        if (this.editMode == 5) {
            Graphics graphics = this.getGraphics();
            Dimension dimension = ((MyComponent)copied.elementAt(0)).getSize();
            this.paint(graphics);
            graphics.setColor(Color.black);
            graphics.drawRect(mouseEvent.getX(), mouseEvent.getY(), dimension.width, dimension.height);
            return;
        }
        if (this.editMode != 0) {
            Graphics graphics = this.getGraphics();
            this.paint(graphics);
            graphics.setColor(Color.black);
            graphics.drawLine(this.pick.getCenter().x, this.pick.getCenter().y, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.editedSinceSave = true;
        if (this.editMode == 0) {
            if (this.pick != null) {
                int n = this.pick.getSize().width / 2;
                int n2 = this.pick.getSize().height / 2;
                int n3 = Math.min(Math.max(mouseEvent.getX() - n, 0), this.getSize().width - 20);
                int n4 = Math.min(Math.max(mouseEvent.getY() - n2, 0), this.getSize().height - 20);
                int n5 = gridSize / 2;
                if (snapToGridOn) {
                    n3 = (n3 + n + n5) / gridSize * gridSize - n;
                    n4 = (n4 + n2 + n5) / gridSize * gridSize - n2;
                }
                Point point = this.pick.getLocation();
                int n6 = point.x - n3;
                int n7 = point.y - n4;
                int n8 = 0;
                while (n8 < this.myComps.size()) {
                    MyComponent myComponent = this.getComp(n8).getLink(0);
                    if (myComponent != null && myComponent == this.pick) {
                        this.getComp(n8).translate(-n6, -n7);
                    }
                    ++n8;
                }
                this.pick.setLocation(n3, n4);
                this.fullRepaint();
                return;
            }
            this.boxRunner.setLocation(mouseEvent.getX(), mouseEvent.getY());
            this.boxRunner.setSize(0, 0);
            this.editMode = 4;
            this.repaint();
            this.boxRunner.start(this.getGraphics());
            this.mbwm.enableEditMenu();
            return;
        }
        if (this.editMode == 4) {
            Point point = this.boxRunner.getLocation();
            this.boxRunner.setSize(mouseEvent.getX() - point.x, mouseEvent.getY() - point.y);
            this.repaint();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.mpum != null) {
            this.mpum.handleClosePopupEvent(mouseEvent.getX(), mouseEvent.getY());
            this.closedPopup = true;
            this.mpum = null;
        } else if (this.editMode == 0) {
            this.pick = this.locateMC(mouseEvent.getX(), mouseEvent.getY());
        }
        if (this.boxRunner.isRunning) {
            this.boxRunner.stop();
            this.mbwm.disableEditMenu();
        }
        this.fullRepaint();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.pick != null) {
            this.pick.grabClosest();
        }
        if (this.editMode == 4) {
            this.editMode = 0;
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.mpum = null;
        this.fullRepaint();
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    static {
        dragLinksTo = true;
    }
}

