/*
 * Decompiled with CFR 0.152.
 */
package mdgawt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import java.util.Vector;
import mdgawt.EditEvent;
import mdgawt.EditableItem;
import mdgawt.EditableListener;
import mdgawt.FTADialog;
import mdgawt.FTAPUM;
import mdgawt.MyCanvas;
import mdgawt.MyComponent;

public class FTA
extends MyComponent
implements EditableItem {
    public static final int FREE = 0;
    public static final int LINKED = 1;
    public static final int BOUND = 2;
    public static final int TOP = 0;
    public static final int BOTTOM = 1;
    public static final int RIGHT = 2;
    public static final int LEFT = 3;
    public static final int REPAINT = 0;
    public static final int BIND = 1;
    public static final int DELETE = 2;
    public static Color free = new Color(0, 0, 0);
    public static Color freeText = new Color(255, 255, 255);
    public static Color tagLink = new Color(0, 0, 0);
    public static boolean boxesOn = true;
    private int type = 0;
    private Vector listeners = new Vector(4, 4);
    protected int lineHeight;
    protected String[] lines;
    protected int numLines;
    public boolean hasBeenEdited = true;
    protected boolean bindMe = false;
    protected Graphics gg;

    public FTA(String string, int n, int n2, Graphics graphics) {
        this.type = 0;
        this.gg = graphics;
        this.setText(string);
        this.setLocation(n, n2);
        this.setup();
    }

    public FTA(int n, int n2, MyComponent myComponent, Graphics graphics) {
        this("", n, n2, myComponent, graphics);
        this.bind();
        this.setup();
    }

    public FTA(String string, int n, int n2, MyComponent myComponent, Graphics graphics) {
        this.gg = graphics;
        if (string.length() == 0) {
            this.setText("empty");
        } else {
            this.setText(string);
        }
        this.setLocation(n, n2);
        this.linkTo(myComponent);
        this.setup();
    }

    public static void setBoxesOn(boolean bl) {
        boxesOn = bl;
    }

    public static boolean getBoxesOn() {
        return boxesOn;
    }

    public int getType() {
        return this.type;
    }

    public MyComponent getLink(int n) {
        if (this.links.size() > n) {
            return (MyComponent)this.links.elementAt(n);
        }
        return null;
    }

    public MyComponent getLink() {
        return this.getLink(0);
    }

    public void setText(String string) {
        super.setText(string);
        this.hasBeenEdited = true;
    }

    public void loadText(String string) {
        String string2 = "";
        try {
            String string3;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(string)));
            while ((string3 = bufferedReader.readLine()) != null) {
                string2 = new String(String.valueOf(string2) + string3 + '\n');
            }
            this.setText(string2);
            return;
        }
        catch (IOException iOException) {
            System.err.println(iOException);
            return;
        }
    }

    public void unlink() {
        this.type = 0;
        this.hasBeenEdited = true;
        this.links.removeAllElements();
    }

    public void unbind() {
        this.type = 1;
        this.hasBeenEdited = true;
    }

    public void bind() {
        if (this.type == 1) {
            this.type = 2;
            this.hasBeenEdited = true;
        }
    }

    public void addLink(MyComponent myComponent) {
        this.linkTo(myComponent);
        if (this.bindMe) {
            this.bind();
        }
        this.bindMe = false;
    }

    public void linkTo(MyComponent myComponent) {
        if (myComponent != null) {
            this.links.addElement(myComponent);
            this.type = 1;
        }
    }

    public void retract(int n) {
        this.retract(n, 0);
    }

    public void retract(int n, int n2) {
        if (this.type == 0) {
            return;
        }
        MyComponent myComponent = this.getLink();
        Point point = myComponent.getLocation();
        this.getLocation();
        Dimension dimension = myComponent.getSize();
        Dimension dimension2 = this.getSize();
        if (n == 0) {
            this.setLocation(point.x + dimension.width / 2 - dimension2.width / 2, point.y - dimension2.height - 5 - n2);
            return;
        }
        if (n == 1) {
            this.setLocation(point.x + dimension.width / 2 - dimension2.width / 2, point.y + dimension.height + 5 + n2);
            return;
        }
        if (n == 2) {
            this.setLocation(point.x + dimension.width + 5 + n2, point.y + dimension.height / 2 - dimension2.height / 2);
            return;
        }
        if (n == 3) {
            this.setLocation(point.x - dimension2.width - 5 - n2, point.y + dimension.height / 2 - dimension2.height / 2);
        }
    }

    protected void setup() {
        if (this.parent == null) {
            this.hasBeenEdited = true;
            return;
        }
        this.gg = this.parent.getGraphics();
        if (this.gg == null) {
            return;
        }
        MyComponent myComponent = this.getLink();
        int n = 9;
        FontMetrics fontMetrics = this.gg.getFontMetrics();
        this.lineHeight = fontMetrics.getHeight();
        if (this.type == 2) {
            this.setText(myComponent.getText());
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.getText(), "\n");
        this.numLines = stringTokenizer.countTokens();
        this.lines = new String[this.numLines];
        int n2 = 0;
        while (n2 < this.numLines) {
            this.lines[n2] = stringTokenizer.nextToken();
            if (fontMetrics.stringWidth(this.lines[n2]) > n) {
                n = fontMetrics.stringWidth(this.lines[n2]);
            }
            ++n2;
        }
        this.setSize(n + 7, fontMetrics.getHeight() * Math.max(this.numLines, 1) + fontMetrics.getDescent());
    }

    public void paint(Graphics graphics) {
        Point point = this.getLocation();
        MyComponent myComponent = this.getLink();
        if (this.hasBeenEdited || this.type == 2) {
            this.gg = graphics;
            this.setup();
        }
        if (this.type == 0) {
            this.setBackground(free);
            this.setForeground(freeText);
        } else if (this.type == 1) {
            this.setBackground(myComponent.getTextBackground());
            this.setForeground(myComponent.getTextForeground());
        } else if (this.type == 2) {
            this.setBackground(myComponent.getNameBackground());
            this.setForeground(myComponent.getNameForeground());
        }
        if (boxesOn) {
            this.drawBox(graphics);
        }
        graphics.setColor(this.getForeground());
        int n = 0;
        int n2 = 0;
        while (n < this.numLines) {
            graphics.drawString(this.lines[n], point.x + 4, point.y + 2 * this.lineHeight / 3 + 4 + n2);
            ++n;
            n2 += this.lineHeight;
        }
    }

    protected void drawBox(Graphics graphics) {
        Point point = this.getLocation();
        Dimension dimension = this.getSize();
        graphics.setColor(this.getBackground());
        graphics.fillRoundRect(point.x, point.y, dimension.width, dimension.height, 8, 8);
        graphics.setColor(Color.black);
        graphics.drawRoundRect(point.x, point.y, dimension.width, dimension.height, 8, 8);
        if (this.type == 1 || this.type == 2) {
            int n = 0;
            while (n < this.links.size()) {
                int n2;
                Point point2 = this.getCenter();
                graphics.setColor(this.getBackground());
                int n3 = this.getDirection(this.getLink(n));
                if (n3 == 0) {
                    n2 = 3;
                    while (n2 > -1) {
                        graphics.drawLine(point2.x - n2, point.y - 3 + n2, point2.x + n2, point.y - 3 + n2);
                        --n2;
                    }
                    graphics.setColor(Color.black);
                    graphics.drawLine(point2.x - 4, point.y, point2.x, point.y - 4);
                    graphics.drawLine(point2.x + 4, point.y, point2.x, point.y - 4);
                } else if (n3 == 1) {
                    n2 = 3;
                    while (n2 > -1) {
                        graphics.drawLine(point2.x - n2, point.y + dimension.height + 3 - n2, point2.x + n2, point.y + dimension.height + 3 - n2);
                        --n2;
                    }
                    graphics.setColor(Color.black);
                    graphics.drawLine(point2.x - 4, point.y + dimension.height, point2.x, point.y + 4 + dimension.height);
                    graphics.drawLine(point2.x + 4, point.y + dimension.height, point2.x, point.y + 4 + dimension.height);
                } else if (n3 == 2) {
                    n2 = 3;
                    while (n2 > -1) {
                        graphics.drawLine(point.x + this.width + 3 - n2, point2.y - n2, point.x + this.width + 3 - n2, point2.y + n2);
                        --n2;
                    }
                    graphics.setColor(Color.black);
                    graphics.drawLine(point.x + this.width, point2.y - 4, point.x + this.width + 4, point2.y);
                    graphics.drawLine(point.x + this.width, point2.y + 4, point.x + this.width + 4, point2.y);
                } else {
                    n2 = 3;
                    while (n2 > -1) {
                        graphics.drawLine(point.x - 3 + n2, point2.y - n2, point.x - 3 + n2, point2.y + n2);
                        --n2;
                    }
                    graphics.setColor(Color.black);
                    graphics.drawLine(point.x, point2.y - 4, point.x - 4, point2.y);
                    graphics.drawLine(point.x, point2.y + 4, point.x - 4, point2.y);
                }
                ++n;
            }
        }
    }

    private int getDirection(MyComponent myComponent) {
        Point point = myComponent.getCenter();
        Point point2 = this.getCenter();
        if (Math.abs(point.x - point2.x) < Math.abs(point.y - point2.y)) {
            if (point.y > point2.y) {
                return 1;
            }
            return 0;
        }
        if (point.x > point2.x) {
            return 2;
        }
        return 3;
    }

    public void paintLink(Graphics graphics) {
        if (this.type == 0) {
            return;
        }
        if (this.hasBeenEdited) {
            this.setup();
        }
        int n = 0;
        while (n < this.links.size()) {
            int n2;
            int n3;
            MyComponent myComponent = (MyComponent)this.links.elementAt(n);
            Point point = myComponent.getCenter();
            Point point2 = this.getCenter();
            Point point3 = this.getLocation();
            Dimension dimension = this.getSize();
            graphics.setColor(tagLink);
            int n4 = this.getDirection(this.getLink(n));
            if (n4 == 0) {
                n3 = point2.x;
                n2 = point3.y - 4;
            } else if (n4 == 1) {
                n3 = point2.x;
                n2 = point3.y + dimension.height + 4;
            } else if (n4 == 2) {
                n3 = point3.x + dimension.width + 4;
                n2 = point2.y;
            } else {
                n3 = point3.x - 4;
                n2 = point2.y;
            }
            graphics.drawLine(n3, n2, point.x, point.y);
            ++n;
        }
    }

    public void createDialog(Component component) {
        MyComponent myComponent = this.getLink();
        if (this.type == 2) {
            myComponent.createDialog(component);
            return;
        }
        FTADialog fTADialog = new FTADialog(component, this);
        ((Component)fTADialog).setVisible(true);
    }

    public void createPopupMenu(MyCanvas myCanvas) {
        new FTAPUM(myCanvas, this);
    }

    public void addEditableListener(EditableListener editableListener) {
        this.listeners.addElement(editableListener);
    }

    public void removeEditableListener(EditableListener editableListener) {
        this.listeners.removeElement(editableListener);
    }

    protected void fireEvent(int n) {
        int n2 = 0;
        while (n2 < this.listeners.size()) {
            ((EditableListener)this.listeners.elementAt(n2)).itemEdited(new EditEvent(this, this, n));
            ++n2;
        }
    }
}

