/*
 * Decompiled with CFR 0.152.
 */
package tm2;

import dialog.InsDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import mdgawt.MyCanvas;
import mdgawt.MyComponent;
import tm2.Alphabet;
import tm2.IPUM;
import tm2.State;
import tm2.TMG;
import tm2.Tape;

public class Ins
extends MyComponent {
    public static final char RIGHT = 'R';
    public static final char LEFT = 'L';
    public static final char STAY = 'S';
    public static final int VERTICAL = 0;
    public static final int HORIZONTAL = 1;
    public static String separator1 = " ";
    public static String separator2 = " ";
    public static char seperator = (char)47;
    public static int gap = 10;
    public static Color nameBackground = new Color(0, 0, 0);
    public static Color nameForeground = new Color(0, 0, 0);
    public static Color textBackground = new Color(0, 0, 0);
    public static Color textForeground = new Color(0, 0, 0);
    public static Color tab = new Color(0, 0, 0);
    public static Color current = new Color(0, 0, 0);
    public static Alphabet alphabet = new Alphabet();
    public static int stringType = 1;
    private char[] read;
    private char[] write;
    private char[] dir;
    public int count;

    public Ins(State state, String string, String string2, String string3, State state2, int n, int n2) {
        this.setup(state, string, string2, string3, state2, n, n2);
    }

    public Ins(State state, String string, State state2, int n, int n2) {
        int n3 = string.length() / 3;
        String string2 = string.substring(0, n3);
        String string3 = string.substring(n3, n3 * n3);
        String string4 = string.substring(n3 * n3);
        this.setup(state, string2, string3, string4, state2, n, n2);
    }

    private void setup(State state, String string, String string2, String string3, State state2, int n, int n2) {
        if (state != null) {
            this.links.addElement(state);
        }
        if (state2 != null) {
            this.links.addElement(state2);
        }
        this.read = new char[5];
        this.write = new char[5];
        this.dir = new char[5];
        int n3 = 0;
        while (n3 < string.length()) {
            this.read[n3] = string.charAt(n3);
            ++n3;
        }
        int n4 = 0;
        while (n4 < string2.length()) {
            this.write[n4] = string2.charAt(n4);
            ++n4;
        }
        int n5 = 0;
        while (n5 < string3.length()) {
            this.dir[n5] = string3.charAt(n5);
            ++n5;
        }
        this.setLocation(n, n2);
        this.setSize(8, 8);
    }

    public char getRead(int n) {
        return this.read[n];
    }

    public void setRead(int n, char c) {
        this.read[n] = c;
    }

    public char getWrite(int n) {
        return this.write[n];
    }

    public void setWrite(int n, char c) {
        this.write[n] = c;
    }

    public char getDirection(int n) {
        return this.dir[n];
    }

    public void setDirection(int n, char c) {
        this.dir[n] = c;
    }

    public boolean matchReads(Ins ins) {
        return this.matchReads(ins.read);
    }

    public boolean matchReads(char[] cArray) {
        int n = 0;
        while (n < Tape.getNumTapes()) {
            if (this.read[n] != cArray[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int getWildcardWeight() {
        int n = 0;
        int n2 = Tape.getNumTapes();
        int n3 = 0;
        while (n3 < n2) {
            if (this.read[n3] == Alphabet.wildcard) {
                n = (int)((double)n + Math.pow(10.0, n2 - n3 - 1) * 2.0);
            }
            ++n3;
        }
        return n;
    }

    public int getCopyWeight() {
        int n = 0;
        int n2 = Tape.getNumTapes();
        int n3 = 0;
        while (n3 < n2) {
            if (this.read[n3] == Alphabet.copy) {
                n = (int)((double)n + Math.pow(10.0, n2 - n3 - 1));
            }
            ++n3;
        }
        return n;
    }

    public State getTo() {
        return (State)this.getLink(1);
    }

    public State getFrom() {
        return (State)this.getLink(0);
    }

    public String getRead() {
        return new String(this.read).substring(0, Tape.getNumTapes());
    }

    public String getWrite() {
        return new String(this.write).substring(0, Tape.getNumTapes());
    }

    public String getDir() {
        return new String(this.dir).substring(0, Tape.getNumTapes());
    }

    public void setRead(String string) {
        int n = Math.min(Tape.getNumTapes(), string.length());
        int n2 = 0;
        while (n2 < n) {
            this.read[n2] = string.charAt(n2);
            ++n2;
        }
    }

    public void setWrite(String string) {
        int n = Math.min(Tape.getNumTapes(), string.length());
        int n2 = 0;
        while (n2 < n) {
            this.write[n2] = string.charAt(n2);
            ++n2;
        }
    }

    public void setDir(String string) {
        int n = Math.min(Tape.getNumTapes(), string.length());
        int n2 = 0;
        while (n2 < n) {
            this.dir[n2] = string.charAt(n2);
            ++n2;
        }
    }

    public Color getNameForeground() {
        return nameForeground;
    }

    public Color getNameBackground() {
        return nameBackground;
    }

    public Color getTextForeground() {
        return textForeground;
    }

    public Color getTextBackground() {
        return textBackground;
    }

    public void linkTo(State state) {
        if (state != null) {
            this.links.setElementAt(state, 1);
        }
    }

    public void paintLink(Graphics graphics) {
        super.paintLink(graphics);
    }

    public void paint(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        Point point = this.getLocation();
        if (this == TMG.currentIns) {
            graphics.setColor(current);
        } else {
            graphics.setColor(tab);
        }
        graphics.fillOval(point.x, point.y, 8, 8);
        graphics.setColor(Color.black);
        graphics.drawOval(point.x, point.y, 8, 8);
    }

    public String getText() {
        StringBuffer stringBuffer = new StringBuffer("");
        int n = TMG.getType();
        if (stringType == 1) {
            if (n == 3 || n == 2) {
                int n2 = 0;
                while (n2 < Tape.getNumTapes()) {
                    stringBuffer.append(this.read[n2] + separator1 + this.write[n2] + separator2 + this.dir[n2] + '\n');
                    ++n2;
                }
            } else {
                int n3 = 0;
                while (n3 < Tape.getNumTapes()) {
                    stringBuffer.append("" + this.read[n3] + '\n');
                    ++n3;
                }
            }
            return stringBuffer.toString();
        }
        int n4 = 0;
        while (n4 < Tape.getNumTapes()) {
            stringBuffer.append(this.read[n4]);
            ++n4;
        }
        if (n == 3 || n == 2) {
            stringBuffer.append(separator1);
            int n5 = 0;
            while (n5 < Tape.getNumTapes()) {
                stringBuffer.append(this.write[n5]);
                ++n5;
            }
            stringBuffer.append(separator2);
            int n6 = 0;
            while (n6 < Tape.getNumTapes()) {
                stringBuffer.append(this.dir[n6]);
                ++n6;
            }
        }
        return stringBuffer.toString();
    }

    public void createDialog(Component component) {
        InsDialog insDialog = new InsDialog((TMG)component, this);
        ((Component)insDialog).setVisible(true);
    }

    public void createPopupMenu(MyCanvas myCanvas) {
        new IPUM((TMG)myCanvas, this);
    }
}

