/*
 * Decompiled with CFR 0.152.
 */
package mdgawt;

import mdgawt.FPoint;

public class Vector2d {
    public double x;
    public double y;

    public Vector2d(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public Vector2d(FPoint fPoint, FPoint fPoint2) {
        this.x = fPoint2.x - fPoint.x;
        this.y = fPoint2.y - fPoint.y;
    }

    public Vector2d getScaled(double d) {
        return new Vector2d(this.x * d, this.y * d);
    }

    public Vector2d subtract(Vector2d vector2d) {
        return new Vector2d(this.x - vector2d.x, this.y - vector2d.y);
    }

    public static double angleBetween(Vector2d vector2d, Vector2d vector2d2) {
        return Math.acos(vector2d.dotProduct(vector2d2) / (vector2d.norm() * vector2d2.norm()));
    }

    public double dotProduct(Vector2d vector2d) {
        return this.x * vector2d.x + this.y * vector2d.y;
    }

    public void normalize() {
        double d = this.norm();
        this.x /= d;
        this.y /= d;
    }

    public void rotate(double d) {
        double d2 = d * Math.PI / 180.0;
        double d3 = this.x;
        this.x = this.x * Math.cos(d2) - this.y * Math.sin(d2);
        this.y = d3 * Math.sin(d2) + this.y * Math.cos(d2);
    }

    public double norm() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public static double distance(FPoint fPoint, FPoint fPoint2) {
        return Math.sqrt((fPoint.x - fPoint2.x) * (fPoint.x - fPoint2.x) + (fPoint.y - fPoint2.y) * (fPoint.y - fPoint2.y));
    }

    public String toString() {
        return new String("(" + this.x + "," + this.y + ")");
    }
}

