/*
 * Decompiled with CFR 0.152.
 */
package mdgawt;

import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import mdgawt.PlusMinusButton;
import mdgawt.SettingEvent;
import mdgawt.SettingItem;
import mdgawt.SettingListener;
import mdgawt.SmallCounter;

public class UpDownCounter
extends Panel
implements Runnable,
ItemListener,
SettingItem {
    public static final int UP = 1;
    public static final int DOWN = -1;
    private boolean isRunning;
    private Vector listeners = new Vector(4, 4);
    private int dir;
    private int min;
    private int max;
    private Thread tt;
    SmallCounter upw;
    PlusMinusButton plusButton;
    PlusMinusButton minusButton;

    public UpDownCounter(int n, int n2) {
        this.min = n;
        this.max = n2;
        if (this.min < 0) {
            this.min = 0;
        }
        if (this.min > this.max) {
            this.min = 0;
            this.max = 100;
        }
        this.setSize(Integer.toString(this.max).length() * 6 + 8 + 32, 16);
        this.setLayout(new FlowLayout(0, 0, 0));
        this.plusButton = new PlusMinusButton(1);
        this.plusButton.addItemListener(this);
        this.add(this.plusButton);
        this.upw = new SmallCounter(this.min, Integer.toString(this.max).length());
        this.add(this.upw);
        this.minusButton = new PlusMinusButton(2);
        this.minusButton.addItemListener(this);
        this.add(this.minusButton);
    }

    public void setColors(Color color, Color color2, Color color3, Color color4) {
        this.plusButton.button = this.minusButton.button = color;
        this.plusButton.buttonSign = this.minusButton.buttonSign = color2;
        this.upw.setColors(color3, color4);
    }

    public void setValue(int n) {
        this.upw.num = n;
        this.upw.repaint();
        this.fireEvent();
    }

    public int getValue() {
        return this.upw.num;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void start() {
        this.tt = new Thread(this);
        this.tt.start();
    }

    public void stop() {
        this.isRunning = false;
        this.upw.repaint();
    }

    public void run() {
        int n = 400;
        this.isRunning = true;
        while (this.isRunning) {
            if (n > 0) {
                n -= n / 5;
            }
            if (this.upw.num + this.dir <= this.max && this.upw.num + this.dir >= this.min) {
                this.setValue(this.upw.num + this.dir);
            }
            this.upw.repaint();
            try {
                Thread.sleep(n + 5 - Math.min((this.max - this.min) / 200, 5));
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public int getSetting() {
        return this.getValue();
    }

    public void addSettingListener(SettingListener settingListener) {
        this.listeners.addElement(settingListener);
    }

    public void removeSettingListener(SettingListener settingListener) {
        this.listeners.removeElement(settingListener);
    }

    protected void fireEvent() {
        int n = 0;
        while (n < this.listeners.size()) {
            ((SettingListener)this.listeners.elementAt(n)).settingChanged(new SettingEvent(this, this));
            ++n;
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getItem();
        if (object instanceof PlusMinusButton) {
            if (itemEvent.getStateChange() == 1) {
                this.dir = ((PlusMinusButton)object).getDirection() == 1 ? 1 : -1;
                this.start();
                return;
            }
            this.stop();
        }
    }
}

