/*
 * Decompiled with CFR 0.152.
 */
package mdgawt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import mdgawt.NUMS;

public class BigCounter
extends Component
implements Runnable {
    public static final int FIXED = 0;
    public static final int VARIABLE = 1;
    public static Color counter = Color.black;
    public static Color number = Color.black;
    public static Color shade = Color.black;
    protected int numDigits;
    protected int type;
    protected Graphics bg;
    protected int num;
    protected int refreshDelay = 500;
    protected Thread tt;
    protected Image b;
    protected boolean isRunning = false;

    public BigCounter(int n, int n2) {
        this.type = 0;
        this.num = n;
        this.numDigits = n2;
        this.createBuffer();
    }

    public BigCounter() {
    }

    public BigCounter(int n) {
        this.type = 1;
        this.num = n;
        this.numDigits = Integer.toString(this.num).length();
        this.createBuffer();
    }

    public void setValue(int n) {
        this.num = n;
    }

    public int getValue() {
        return this.num;
    }

    public void adv() {
        ++this.num;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.numDigits * 18 + 6, 24);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void start() {
        if (this.isRunning) {
            return;
        }
        this.tt = new Thread(this);
        this.tt.start();
    }

    public void stop() {
        this.isRunning = false;
    }

    public void run() {
        this.isRunning = true;
        while (this.isRunning) {
            this.paint(this.getGraphics());
            try {
                Thread.sleep(this.refreshDelay);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.repaint();
    }

    public synchronized void createBuffer() {
        int n = this.numDigits * 18 + 6;
        this.setSize(n, 24);
        if (this.getParent() != null) {
            this.getParent().doLayout();
        }
        this.b = this.createImage(n, 24);
    }

    public synchronized void update(Graphics graphics) {
        this.paint(graphics);
    }

    public synchronized void paint(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        String string = Integer.toString(this.num);
        int n = string.length();
        if (this.type == 1 && n != this.numDigits) {
            this.numDigits = n;
            this.createBuffer();
        }
        if (this.b == null) {
            this.createBuffer();
        }
        int n2 = this.getSize().width;
        this.bg = this.b.getGraphics();
        this.bg.setColor(shade);
        this.bg.fillRect(1, 1, n2, 23);
        this.bg.setColor(counter);
        int n3 = 0;
        while (n3 < 8) {
            this.bg.drawLine(1, 1 + n3 * 3, n2 - 1, 1 + n3 * 3);
            ++n3;
        }
        int n4 = 0;
        while (n4 <= n2 / 3) {
            this.bg.drawLine(1 + n4 * 3, 1, 1 + n4 * 3, 22);
            ++n4;
        }
        this.bg.setColor(Color.white);
        this.bg.drawLine(0, 0, n2 - 1, 0);
        this.bg.drawLine(0, 0, 0, 23);
        this.bg.setColor(Color.darkGray);
        this.bg.drawLine(0, 23, n2 - 1, 23);
        this.bg.drawLine(n2 - 1, 23, n2 - 1, 1);
        this.bg.setColor(number);
        int n5 = 5;
        if (this.type == 0) {
            n5 += (this.numDigits - n) * 18;
        }
        int n6 = 0;
        while (n6 < n) {
            int n7 = string.charAt(n6) - 48;
            int n8 = 0;
            while (n8 < 7) {
                int n9 = 0;
                while (n9 < 5) {
                    if (NUMS.num[n7][n8 * 5 + n9] == 1) {
                        this.bg.fillRect(n5 + n9 * 3, 2 + n8 * 3, 2, 2);
                    }
                    ++n9;
                }
                ++n8;
            }
            ++n6;
            n5 += 18;
        }
        graphics.drawImage(this.b, 0, 0, this);
    }
}

