#!/bin/sh

# panic: handle_workitem_remove: bad file delta
# cpuid = 2
# time = 1753799597
# KDB: stack backtrace:
# db_trace_self_wrapper() at db_trace_self_wrapper+0x2b/frame 0xfffffe00ffc84b70
# vpanic() at vpanic+0x136/frame 0xfffffe00ffc84ca0
# panic() at panic+0x43/frame 0xfffffe00ffc84d00
# handle_workitem_remove() at handle_workitem_remove+0x68d/frame 0xfffffe00ffc84d70
# handle_workitem_remove() at handle_workitem_remove+0x52d/frame 0xfffffe00ffc84de0
# process_worklist_item() at process_worklist_item+0x21e/frame 0xfffffe00ffc84e70
# softdep_process_worklist() at softdep_process_worklist+0xbd/frame 0xfffffe00ffc84eb0
# softdep_flush() at softdep_flush+0x10f/frame 0xfffffe00ffc84ef0
# fork_exit() at fork_exit+0x82/frame 0xfffffe00ffc84f30
# fork_trampoline() at fork_trampoline+0xe/frame 0xfffffe00ffc84f30
# --- trap 0, rip = 0, rsp = 0, rbp = 0 ---
# KDB: enter: panic
# [ thread pid 16 tid 100253 ]
# Stopped at      kdb_enter+0x33: movq    $0,0x1230852(%rip)
# db> x/s version
# version: FreeBSD 15.0-CURRENT #0 main-n279158-f1f77adfd9bc-dirty: Tue Jul 29 15:49:28 CEST 2025
# pho@mercat1.netperf.freebsd.org:/usr/src/sys/amd64/compile/PHO

[ `id -u ` -ne 0 ] && echo "Must be root!" && exit 1

. ../default.cfg
set -u
prog=$(basename "$0" .sh)
cat > /tmp/$prog.c <<EOF
// https://syzkaller.appspot.com/bug?id=0a60b828818a364deb4721d58b2ed5167b1f6296
// autogenerated by syzkaller (https://github.com/google/syzkaller)

#define _GNU_SOURCE

#include <sys/types.h>

#include <pwd.h>
#include <signal.h>
#include <stdarg.h>
#include <stdbool.h>
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/endian.h>
#include <sys/syscall.h>
#include <sys/wait.h>
#include <time.h>
#include <unistd.h>

static void kill_and_wait(int pid, int* status)
{
  kill(pid, SIGKILL);
  while (waitpid(-1, status, 0) != pid) {
  }
}

static void sleep_ms(uint64_t ms)
{
  usleep(ms * 1000);
}

static uint64_t current_time_ms(void)
{
  struct timespec ts;
  if (clock_gettime(CLOCK_MONOTONIC, &ts))
    exit(1);
  return (uint64_t)ts.tv_sec * 1000 + (uint64_t)ts.tv_nsec / 1000000;
}

static void execute_one(void);

#define WAIT_FLAGS 0

static void loop(void)
{
//  int iter = 0;
  for (;; /*iter++*/) {
    int pid = fork();
    if (pid < 0)
      exit(1);
    if (pid == 0) {
      execute_one();
      exit(0);
    }
    int status = 0;
    uint64_t start = current_time_ms();
    for (;;) {
      sleep_ms(10);
      if (waitpid(-1, &status, WNOHANG | WAIT_FLAGS) == pid)
        break;
      if (current_time_ms() - start < 5000)
        continue;
      kill_and_wait(pid, &status);
      break;
    }
  }
}

uint64_t r[3] = {0xffffffffffffffff, 0xffffffffffffffff, 0xffffffffffffffff};

void execute_one(void)
{
  intptr_t res = 0;
  if (write(1, "executing program\n", sizeof("executing program\n") - 1)) {
  }
  memcpy((void*)0x200000000180, "./file0\000", 8);
  syscall(SYS_mkdir, /*path=*/0x200000000180ul, /*mode=*/0ul);
  memcpy((void*)0x200000000000, "./file0/file0\000", 14);
  syscall(SYS_mkdir, /*path=*/0x200000000000ul, /*mode=*/0ul);
  memcpy((void*)0x200000000080, ".\000", 2);
  res = syscall(SYS_open, /*file=*/0x200000000080ul,
                /*flags=O_DIRECT*/ 0x10000ul, /*mode=*/0ul);
  if (res != -1)
    r[0] = res;
  memcpy((void*)0x200000000080, ".\000", 2);
  res =
      syscall(SYS_open, /*file=*/0x200000000080ul, /*flags=*/0ul, /*mode=*/0ul);
  if (res != -1)
    r[1] = res;
  memcpy((void*)0x200000000080, ".\000", 2);
  res = syscall(SYS_open, /*file=*/0x200000000080ul, /*flags=O_NONBLOCK*/ 4ul,
                /*mode=*/0ul);
  if (res != -1)
    r[2] = res;
  memcpy((void*)0x200000000100, "./file1\000", 8);
  syscall(SYS_mkdirat, /*fd=*/r[2], /*path=*/0x200000000100ul,
          /*mode=S_IROTH|S_IWUSR*/ 0x84ul);
  memcpy((void*)0x200000000340, "./file0/file0\000", 14);
  memcpy((void*)0x200000000380, "./file1\000", 8);
  syscall(SYS_renameat, /*oldfd=*/r[0], /*old=*/0x200000000340ul,
          /*newfd=*/r[1], /*new=*/0x200000000380ul);
}
int main(void)
{
  syscall(SYS_mmap, /*addr=*/0x200000000000ul, /*len=*/0x1000000ul,
          /*prot=PROT_WRITE|PROT_READ|PROT_EXEC*/ 7ul,
          /*flags=MAP_FIXED|MAP_ANONYMOUS|MAP_PRIVATE*/ 0x1012ul,
          /*fd=*/(intptr_t)-1, /*offset=*/0ul);
  const char* reason;
  (void)reason;
  loop();
  return 0;
}
EOF
mycc -o /tmp/$prog -Wall -Wextra -O0 /tmp/$prog.c || exit 1

(cd ../testcases/swap; ./swap -t 3m -i 30 -l 100 > /dev/null 2>&1) &
sleep 5

work=/tmp/$prog.dir
rm -rf $work
mkdir $work
cd /tmp/$prog.dir
for i in `jot 30`; do
	(
		mkdir d$i
		cd d$i
		timeout 3m /tmp/$prog > /dev/null 2>&1 &
	)
done
while pgrep -q $prog; do sleep 2; done
while pkill swap; do :; done
wait

rm -rf /tmp/$prog /tmp/$prog.c /tmp/$prog.core /tmp/$prog.?????? $work
exit 0
