--- ext/node/polyfills/internal_binding/constants.ts.orig	2025-03-30 15:55:39 UTC
+++ ext/node/polyfills/internal_binding/constants.ts
@@ -332,6 +332,137 @@ if (buildOs === "darwin") {
       PRIORITY_HIGHEST: -20,
     },
   };
+} else if (buildOs === "freebsd") {
+  os = {
+    UV_UDP_REUSEADDR: 4,
+    dlopen: {
+      RTLD_LAZY: 1,
+      RTLD_NOW: 2,
+      RTLD_GLOBAL: 256,
+      RTLD_LOCAL: 0,
+      RTLD_DEEPBIND: 16384,
+    },
+    errno: {
+     E2BIG: 7,
+     EACCES: 13,
+     EADDRINUSE: 48,
+     EADDRNOTAVAIL: 49,
+     EAFNOSUPPORT: 47,
+     EAGAIN: 35,
+     EALREADY: 37,
+     EBADF: 9,
+     EBADMSG: 89,
+     EBUSY: 16,
+     ECANCELED: 85,
+     ECHILD: 10,
+     ECONNABORTED: 53,
+     ECONNREFUSED: 61,
+     ECONNRESET: 54,
+     EDEADLK: 11,
+     EDESTADDRREQ: 39,
+     EDOM: 33,
+     EDQUOT: 69,
+     EEXIST: 17,
+     EFAULT: 14,
+     EFBIG: 27,
+     EHOSTUNREACH: 65,
+     EIDRM: 82,
+     EILSEQ: 86,
+     EINPROGRESS: 36,
+     EINTR: 4,
+     EINVAL: 22,
+     EIO: 5,
+     EISCONN: 56,
+     EISDIR: 21,
+     ELOOP: 62,
+     EMFILE: 24,
+     EMLINK: 31,
+     EMSGSIZE: 40,
+     EMULTIHOP: 90,
+     ENAMETOOLONG: 63,
+     ENETDOWN: 50,
+     ENETRESET: 52,
+     ENETUNREACH: 51,
+     ENFILE: 23,
+     ENOBUFS: 55,
+     ENODEV: 19,
+     ENOENT: 2,
+     ENOEXEC: 8,
+     ENOLCK: 77,
+     ENOLINK: 91,
+     ENOMEM: 12,
+     ENOMSG: 83,
+     ENOPROTOOPT: 42,
+     ENOSPC: 28,
+     ENOSYS: 78,
+     ENOTCONN: 57,
+     ENOTDIR: 20,
+     ENOTEMPTY: 66,
+     ENOTSOCK: 38,
+     ENOTSUP: 45,
+     ENOTTY: 25,
+     ENXIO: 6,
+     EOPNOTSUPP: 45,
+     EOVERFLOW: 84,
+     EPERM: 1,
+     EPIPE: 32,
+     EPROTOTYPE: 41,
+     EPROTONOSUPPORT: 43,
+     EPROTO: 92,
+     EPROTONOSUPPORT: 43,
+     EPROTOTYPE: 41,
+     ERANGE: 34,
+     EROFS: 30,
+     ESPIPE: 29,
+     ESRCH: 3,
+     ESTALE: 70,
+     ETIMEDOUT: 60,
+     ETIMEDOUT: 60,
+     ETXTBSY: 26,
+     EWOULDBLOCK: 35,
+     EXDEV: 18,
+    },
+    signals: {
+     SIGHUP: 1,
+     SIGINT: 2,
+     SIGQUIT: 3,
+     SIGILL: 4,
+     SIGTRAP: 5,
+     SIGABRT: 6,
+     SIGIOT: 6,
+     SIGBUS: 10,
+     SIGFPE: 8,
+     SIGKILL: 9,
+     SIGUSR1: 30,
+     SIGSEGV: 11,
+     SIGUSR2: 31,
+     SIGPIPE: 13,
+     SIGALRM: 14,
+     SIGTERM: 15,
+     SIGCHLD: 20,
+     SIGCONT: 19,
+     SIGSTOP: 17,
+     SIGTSTP: 18,
+     SIGTTIN: 21,
+     SIGTTOU: 22,
+     SIGURG: 16,
+     SIGXCPU: 24,
+     SIGXFSZ: 25,
+     SIGVTALRM: 26,
+     SIGPROF: 27,
+     SIGWINCH: 28,
+     SIGIO: 23,
+     SIGSYS: 12,
+    },
+    priority: {
+      PRIORITY_LOW: 19,
+      PRIORITY_BELOW_NORMAL: 10,
+      PRIORITY_NORMAL: 0,
+      PRIORITY_ABOVE_NORMAL: -7,
+      PRIORITY_HIGH: -14,
+      PRIORITY_HIGHEST: -20,
+    },
+  };
 } else if (buildOs === "linux" || buildOs === "android") {
   os = {
     UV_UDP_REUSEADDR: 4,
